IF EXISTS(SELECT * FROM sys.objects
			WHERE  object_id = OBJECT_ID(N'[dbo].[P_EST_WMS_SAI_SAI_VOLUME_PROCESSAR]')
		   AND type IN(N'P', N'PC')
)
	BEGIN
		DROP PROCEDURE [DBO].[P_EST_WMS_SAI_SAI_VOLUME_PROCESSAR];
	END;
GO
--P_EST_WMS_SAI_SAI_VOLUME_PROCESSAR 1,900,3424194,518807

CREATE PROCEDURE P_EST_WMS_SAI_SAI_VOLUME_PROCESSAR(@CD_EMP     INT
														, @CD_FILIAL  INT
														, @CD_CTR     INT
														, @CD_PED_WMS INT
														)
AS
	 BEGIN
		 DECLARE @QTDE_VOLUME INT;
		 SET NOCOUNT ON;

		

		 DECLARE @CD_LACRE INT;
		 SET @CD_LACRE = ISNULL((SELECT MAX(CD_LACRE)
									FROM
										EST_PROD_TRANSF_LACRE
									WHERE  CD_EMP = @CD_EMP
										   AND CD_FILIAL = @CD_FILIAL
										   AND CD_CTR = @CD_CTR
								), 0);


		 CREATE TABLE #RsVolume (ORDEM      INT IDENTITY(1, 1)
								, CD_EMP     INT
								, CD_FILIAL  INT
								, CD_CTR     INT
								, NR_LACRE   VARCHAR(50)
								, NR_VOLUME  INT
								, TP_VOLUME  INT
								, CD_PED_WMS INT
								);

		 INSERT INTO          #RsVolume(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR
			  , NR_LACRE
			  , NR_VOLUME
			  , TP_VOLUME
			  , CD_PED_WMS)
		 SELECT
				@CD_EMP
			  , @CD_FILIAL
			  , @CD_CTR
			  , COALESCE(EST_WMS_SAI_VOLUME.NR_LACRE, '0')
			  , COALESCE(EST_WMS_SAI_VOLUME.NR_VOLUME, '0')
			  , EST_WMS_SAI_VOLUME.TP_VOLUME
			  , EST_WMS_SAI_VOLUME.CD_PED_WMS
		 FROM
			 EST_WMS_SAI_VOLUME
			 INNER JOIN EST_WMS_SAI_VOLUME_PEND ON EST_WMS_SAI_VOLUME.CD_PED_WMS = EST_WMS_SAI_VOLUME_PEND.CD_PED_WMS
												   AND EST_WMS_SAI_VOLUME.NR_VOLUME = EST_WMS_SAI_VOLUME_PEND.NR_VOLUME
		 WHERE  EST_WMS_SAI_VOLUME.CD_PED_WMS = @CD_PED_WMS;

		 print 'line 65';

		 INSERT INTO                      EST_PROD_TRANSF_LACRE(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR
			  , NR_LACRE
			  , CD_USU
			  , DT_CAD
			  , NR_VOLUME
			  , CD_LACRE
			  , TP_VOLUME)
		 SELECT
				V.CD_EMP
			  , V.CD_FILIAL
			  , V.CD_CTR
			  , CASE
					WHEN V.NR_LACRE = '0' THEN convert(VARCHAR(150), @CD_LACRE+ ORDEM)
					ELSE V.NR_LACRE
				END
			  , 1
			  , CONVERT(CHAR(10), GETDATE(), 112)
			  , CASE
					WHEN V.NR_VOLUME = 0 THEN @CD_LACRE + ORDEM
					ELSE V.NR_VOLUME
				END
			  , @CD_LACRE + ORDEM
			  , V.TP_VOLUME
		 FROM
			 #RsVolume V;

			 
		 print 'line 97';

		 INSERT INTO                         EST_PROD_TRANSF_LACRE_IT(
				CD_EMP
			  , CD_FILIAL
			  , CD_CTR
			  , NR_VOLUME
			  , CD_PROD
			  , LOTE
			  , DT_FABRICACAO
			  , DT_VENCTO
			  , QTDE_ITEM
			  , CD_LACRE
			  , NR_LACRE)
		 SELECT
				@CD_EMP
			  , @CD_FILIAL
			  , @CD_CTR
			  , CASE
					WHEN V.NR_VOLUME = 0 THEN @CD_LACRE + ORDEM
					ELSE V.NR_VOLUME
				END
			  , EST_WMS_SAI_VOLUME_IT.CD_PROD
			  , EST_WMS_SAI_VOLUME_IT.LOTE
			  , EST_WMS_SAI_VOLUME_IT.DT_FABR
			  , EST_WMS_SAI_VOLUME_IT.DT_VENCTO
			  , EST_WMS_SAI_VOLUME_IT.QT_PROD
			  , @CD_LACRE + V.ORDEM
			  , CASE
					WHEN V.NR_LACRE = '0' THEN CONVERT(VARCHAR(150), @CD_LACRE + ORDEM)
					ELSE isnull(V.NR_LACRE,'')
				END
		 FROM
			 EST_WMS_SAI_VOLUME_IT
			 INNER JOIN #RsVolume v ON EST_WMS_SAI_VOLUME_IT.CD_PED_WMS = v.CD_PED_WMS
									   AND EST_WMS_SAI_VOLUME_IT.NR_VOLUME = v.NR_VOLUME
			 INNER JOIN EST_WMS_SAI_VOLUME_PEND ON v.CD_PED_WMS = EST_WMS_SAI_VOLUME_PEND.CD_PED_WMS
												   AND v.NR_VOLUME = EST_WMS_SAI_VOLUME_PEND.NR_VOLUME
		 WHERE  EST_WMS_SAI_VOLUME_IT.CD_PED_WMS = @CD_PED_WMS
				AND EST_WMS_SAI_VOLUME_IT.QT_PROD > 0;

		 
		DELETE EST_WMS_SAI_VOLUME_PEND
		FROM #RsVolume v
			INNER JOIN EST_WMS_SAI_VOLUME_PEND ON 
				v.CD_PED_WMS = EST_WMS_SAI_VOLUME_PEND.CD_PED_WMS AND 
				v.NR_VOLUME = EST_WMS_SAI_VOLUME_PEND.NR_VOLUME;

		SET @QTDE_VOLUME = ISNULL((SELECT COUNT(V.CD_PED_WMS) FROM #RsVolume v ), 0);

		IF @QTDE_VOLUME > 0
		BEGIN 
			UPDATE s
		    SET
			   QTDE_VOLUMES = @QTDE_VOLUME
		  FROM EST_PROD_TRANSF s
			  LEFT JOIN EST_PROD_TRANSF_PED_VD t ON t.CD_FILIAL = s.CD_FILIAL
											AND t.CD_EMP = s.CD_EMP
											AND t.CD_CTR = s.CD_CTR
		  WHERE s.CD_EMP = @CD_EMP
			   AND s.CD_FILIAL = @CD_FILIAL
			   AND s.CD_CTR = @CD_CTR
			   AND t.CD_CTR IS NULL; 
		END;
	 END;